"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var imagen_exports = {};
__export(imagen_exports, {
  ImagenConfigSchema: () => ImagenConfigSchema,
  TEST_ONLY: () => TEST_ONLY,
  defineKnownModels: () => defineKnownModels,
  defineModel: () => defineModel,
  isImagenModelName: () => isImagenModelName,
  listActions: () => listActions,
  model: () => model
});
module.exports = __toCommonJS(imagen_exports);
var import_genkit = require("genkit");
var import_model = require("genkit/model");
var import_client = require("./client.js");
var import_utils = require("./utils.js");
const ImagenConfigSchema = import_genkit.z.object({
  apiKey: import_genkit.z.string().describe("Override the API key provided at plugin initialization.").optional(),
  numberOfImages: import_genkit.z.number().describe(
    "The number of images to generate, from 1 to 4 (inclusive). The default is 1."
  ).optional(),
  aspectRatio: import_genkit.z.enum(["1:1", "9:16", "16:9", "3:4", "4:3"]).describe("Desired aspect ratio of the output image.").optional(),
  personGeneration: import_genkit.z.enum(["dont_allow", "allow_adult", "allow_all"]).describe(
    "Control if/how images of people will be generated by the model."
  ).optional()
}).passthrough();
function commonRef(name, info, configSchema = ImagenConfigSchema) {
  return (0, import_model.modelRef)({
    name: `googleai/${name}`,
    configSchema,
    info: info ?? {
      supports: {
        media: true,
        multiturn: false,
        tools: false,
        toolChoice: false,
        systemRole: false,
        output: ["media"]
      }
    }
  });
}
const GENERIC_MODEL = commonRef("imagen", {
  supports: {
    media: true,
    multiturn: true,
    tools: true,
    systemRole: true,
    output: ["media"]
  }
});
const KNOWN_MODELS = {
  "imagen-3.0-generate-002": commonRef("imagen-3.0-generate-002"),
  "imagen-4.0-generate-preview-06-06": commonRef(
    "imagen-4.0-generate-preview-06-06"
  ),
  "imagen-4.0-ultra-generate-preview-06-06": commonRef(
    "imagen-4.0-ultra-generate-preview-06-06"
  )
};
function isImagenModelName(value) {
  return !!value?.startsWith("imagen-");
}
function model(version, config = {}) {
  const name = (0, import_utils.checkModelName)(version);
  if (KNOWN_MODELS[name]) {
    return KNOWN_MODELS[name].withConfig(config);
  }
  return (0, import_model.modelRef)({
    name: `googleai/${name}`,
    config,
    configSchema: ImagenConfigSchema,
    info: {
      ...GENERIC_MODEL.info
    }
  });
}
function listActions(models) {
  return models.filter(
    (m) => m.supportedGenerationMethods.includes("predict") && isImagenModelName((0, import_utils.modelName)(m.name))
  ).filter((m) => !m.description || !m.description.includes("deprecated")).map((m) => {
    const ref = model(m.name);
    return (0, import_genkit.modelActionMetadata)({
      name: ref.name,
      info: ref.info,
      configSchema: ref.configSchema
    });
  });
}
function defineKnownModels(ai, options) {
  for (const name of Object.keys(KNOWN_MODELS)) {
    defineModel(ai, name, options);
  }
}
function defineModel(ai, name, pluginOptions) {
  (0, import_utils.checkApiKey)(pluginOptions?.apiKey);
  const ref = model(name);
  const clientOptions = {
    apiVersion: pluginOptions?.apiVersion,
    baseUrl: pluginOptions?.baseUrl
  };
  return ai.defineModel(
    {
      apiVersion: "v2",
      name: ref.name,
      ...ref.info,
      configSchema: ref.configSchema
    },
    async (request, { abortSignal }) => {
      const clientOpt = { ...clientOptions, signal: abortSignal };
      const imagenPredictRequest = {
        instances: [
          {
            prompt: (0, import_utils.extractText)(request),
            image: (0, import_utils.extractImagenImage)(request)
          }
        ],
        parameters: toImagenParameters(request)
      };
      const predictApiKey = (0, import_utils.calculateApiKey)(
        pluginOptions?.apiKey,
        request.config?.apiKey
      );
      const response = await (0, import_client.imagenPredict)(
        predictApiKey,
        (0, import_utils.extractVersion)(ref),
        imagenPredictRequest,
        clientOpt
      );
      if (!response.predictions || response.predictions.length == 0) {
        throw new Error(
          "Model returned no predictions. Possibly due to content filters."
        );
      }
      const message = {
        role: "model",
        content: response.predictions.map(fromImagenPrediction)
      };
      return {
        finishReason: "stop",
        message,
        usage: (0, import_model.getBasicUsageStats)(request.messages, message),
        custom: response
      };
    }
  );
}
function fromImagenPrediction(p) {
  const b64data = p.bytesBase64Encoded;
  const mimeType = p.mimeType;
  return {
    media: {
      url: `data:${mimeType};base64,${b64data}`,
      contentType: mimeType
    }
  };
}
function toImagenParameters(request) {
  const out = {
    sampleCount: request.config?.numberOfImages ?? 1,
    ...request?.config
  };
  for (const k in out) {
    if (!out[k]) delete out[k];
  }
  delete out.apiKey;
  return out;
}
const TEST_ONLY = {
  toImagenParameters,
  fromImagenPrediction,
  GENERIC_MODEL,
  KNOWN_MODELS
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ImagenConfigSchema,
  TEST_ONLY,
  defineKnownModels,
  defineModel,
  isImagenModelName,
  listActions,
  model
});
//# sourceMappingURL=imagen.js.map